function [fwdKin] = forwardKinematics( z1, z2, z3, roll, tilt )
%Inputs: z1,z2,z3 are the positions of the linear stages in mm, roll is the
%roll angle in radians, and tilt is the tilt angle in radians
%Outputs: x,y,z position of force sensor origin, roll and tilt angles of
%force sensor

[xi yi L d2r r2t t2f f2tool] = deltaParams_mk2();

x1 = xi(1);
y1 = yi(1);
x2 = xi(2);
y2 = yi(2);
x3 = xi(3);
y3 = yi(3);

w1 = x1^2 + y1^2 + z1^2;
w2 = x2^2 + y2^2 + z2^2;
w3 = x3^2 + y3^2 + z3^2;

z32 = z3-z2;
z21 = z2-z1;
x32 = x3-x2;
x21 = x2-x1;
y32 = y3-y2;
y21 = y2-y1;
w32 = w3-w2;
w21 = w2-w1;
y3221 = y32/y21;
x3221 = x32/x21;

a1 = -(z32-z21*y3221)/(x32-x21*y3221);
b1 = (w32-w21*y3221)/(x32-x21*y3221)/2;
a2 = -(z32-z21*x3221)/(y32-y21*x3221);
b2 = (w32-w21*x3221)/(y32-y21*x3221)/2;

a = a1^2 + a2^2 + 1;
b = 2*(a1*(b1-x1)+a2*(b2-y1)-z1);
c = (b1-x1)^2 + (b2-y1)^2 + z1^2-L^2;

if (b^2-4*a*c < 0)
    error('no solution');
else
    zdelta = (-b+sqrt(b^2-4*a*c))/(2*a);
    xdelta = zdelta*a1+b1;
    ydelta = zdelta*a2+b2;
end

protary = d2r + Rx(roll)*(r2t + Ry(tilt)*(t2f + f2tool));

x = protary(1)+xdelta;
y = protary(2)+ydelta;
z = protary(3)+zdelta;

fwdKin = [x;y;z;roll;tilt];

